#include <iostream>
#include <vector>
#include <algorithm>



using namespace std;


vector<int> computeBinaryArray(const vector<int>& arr) {
    vector<int> binaryArr;
    for (int num : arr) {
        binaryArr.push_back(num % 2);
    }
    return binaryArr;
}


pair<int, int> calculateWeightAndCounterWeight(const vector<int>& binaryArr) {
    int weight = 0;
    int n = binaryArr.size();

    for (size_t i = 0; i < n - 1; ++i) {
        if (binaryArr[i] != binaryArr[i + 1]) {
            ++weight; 
        }
    }


    int counterWeight = (n - 1) - weight;
    return {weight, counterWeight};
}


pair<int, int> findMinimumWeightAndCounterWeight(const vector<int>& arr) {

    vector<int> binaryArr = computeBinaryArray(arr);
    int n = binaryArr.size();


    auto [minWeight, minCounterWeight] = calculateWeightAndCounterWeight(binaryArr);


    for (size_t i = 0; i < n - 1; i += 2) {

        swap(binaryArr[i], binaryArr[i + 1]);


        auto [newWeight, newCounterWeight] = calculateWeightAndCounterWeight(binaryArr);

        if (newWeight < minWeight) {
            minWeight = newWeight;
            minCounterWeight = newCounterWeight;
        }

        swap(binaryArr[i], binaryArr[i + 1]);
    }

    return {minWeight, minCounterWeight};
}

int main() {
    int exampleCount;
    cin >> exampleCount; 

    for (int example = 1; example <= exampleCount; ++example) {
        int n;
        cin >> n;

        vector<int> oddElements(n), evenElements(n);
        for (int i = 0; i < n; ++i) {
            cin >> oddElements[i];
        }
        for (int i = 0; i < n; ++i) {
            cin >> evenElements[i];
        }

        vector<int> arr(2 * n);
        for (int i = 0; i < n; ++i) {
            arr[2 * i] = oddElements[i];     
            arr[2 * i + 1] = evenElements[i];
        }


        vector<int> binaryArr = computeBinaryArray(arr);


        auto [minWeight, minCounterWeight] = findMinimumWeightAndCounterWeight(arr);

#ifdef DEBUG
        cout << "Example #" << example << ":" << endl;
        cout << "Initial binary array: ";
        for (int bit : binaryArr) {
            cout << bit << " ";
        }
        cout << endl;
        cout << "Minimum weight: " << minWeight << endl;
        cout << "Counter weight: " << minCounterWeight << endl;
#else
        cout << minCounterWeight << endl;
#endif
    }

    return 0;
}